<xsl:transform version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fn="http://www.w3.org/2005/xpath-functions"		
		xmlns:mx="http://www.mobotix.com/xslfuncs">
		
<xsl:output method="html" encoding="UTF-8"/>
<xsl:strip-space elements="tr td img"/>

<xsl:variable name="translation-context">Easy</xsl:variable> 
<xsl:include href="include.xsl"/>

<xsl:template match="/print">

<html>
<head>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
  <style>
	BODY, TD, TH {
	  	font-family: "VAGRounded LT Thin";
  		font-size: 11pt;
  		color: #002080;
	}
  	TD,TH {
  		text-align:left;
  	}
  	TH {
  		background-color: #eeeeee;
  		text-align: center;
  	}
  	P {
  		text-align:center;
  	}
  	hr {
  		color: #002080;
  		height: 2px;  			
  	}
  	.title {
		font-weight:bold;
		font-size:24pt;
		background-color: #dddddd;
		vertical-align:middle;
	}
  	.header {
  		position: absolute;
  		top:0px;
  	}
  	TD.td-header {
		color: white;
		background-color: #002080;
  	}
  	TD.td-footer {
		color: white;
		background-color: #a0a0a0;
  	}
  </style>
</head>

<body>
<center>

<!--
<table cellspacing="0" border="0" width="100%">
<tr>
	<td class="title" align="center">
		<xsl:call-template name="tr"><xsl:with-param name="source">Mx Easy</xsl:with-param></xsl:call-template>
	</td>
	<td width="180" align="right" bgcolor="#dddddd">
		<img width="175" height="146" border="0">
			<xsl:attribute name="src"><xsl:value-of select="template-path"/>logo.jpg</xsl:attribute>
		</img>
	</td>
</tr>
</table>
-->

<!-- size of a small image -->
<xsl:variable name="w1" select="paper/content/@width div 5"/>
<xsl:variable name="h1" select="(paper/content/@height - 50) div 4"/>
<!-- adjust to 4:3 aspect ratio -->
<xsl:variable name="w2" select="$h1 div 3 * 4"/>
<xsl:variable name="h2" select="$w1 div 4 * 3"/>

<!-- choose the minimum of (w2,h1) and (w1,h2) -->
<!-- and round down to multiples of (4,3) -->
<xsl:variable name="base-width">
	<xsl:choose>
		<xsl:when test="$w2 &lt; $w1"><xsl:value-of select="floor($w2 div 4) * 4"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="floor($w1 div 4) * 4"/></xsl:otherwise>
	</xsl:choose>
</xsl:variable>

<xsl:variable name="base-height">
	<xsl:choose>
		<xsl:when test="$h2 &lt; $h1"><xsl:value-of select="floor($h2 div 3) * 3"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="floor($h1 div 3) * 3"/></xsl:otherwise>
	</xsl:choose>
</xsl:variable>



<table border="0" cellpadding="0" cellspacing="0">
	<xsl:attribute name="width"><xsl:value-of select="$base-width*5"/></xsl:attribute>
<tr>
	<td colspan="2" align="center" class="td-header"><xsl:value-of select="data/header-text"/></td>
</tr>
	
<tr>
	<td>
		<xsl:call-template name="img-scale">
			<xsl:with-param name="img" select="image[1]"/>
			<xsl:with-param name="max-width" select="$base-width*4+4"/>
			<xsl:with-param name="max-height" select="$base-height*4+3"/> 
			<xsl:with-param name="force" select="1"/>
		</xsl:call-template>
	</td>
	<td>
		<xsl:call-template name="img-scale">
			<xsl:with-param name="img" select="image[2]"/>
			<xsl:with-param name="max-width" select="$base-width"/>
			<xsl:with-param name="max-height" select="$base-height"/> 
			<xsl:with-param name="force" select="1"/>
		</xsl:call-template><br/>
		<xsl:call-template name="img-scale">
			<xsl:with-param name="img" select="image[3]"/>
			<xsl:with-param name="max-width" select="$base-width"/>
			<xsl:with-param name="max-height" select="$base-height"/> 
			<xsl:with-param name="force" select="1"/>
		</xsl:call-template><br/>
		<xsl:call-template name="img-scale">
			<xsl:with-param name="img" select="image[4]"/>
			<xsl:with-param name="max-width" select="$base-width"/>
			<xsl:with-param name="max-height" select="$base-height"/> 
			<xsl:with-param name="force" select="1"/>
		</xsl:call-template><br/>
		<xsl:call-template name="img-scale">
			<xsl:with-param name="img" select="image[5]"/>
			<xsl:with-param name="max-width" select="$base-width"/>
			<xsl:with-param name="max-height" select="$base-height"/> 
			<xsl:with-param name="force" select="1"/>
		</xsl:call-template>
	</td>
</tr>

<tr>
	<td colspan="2" align="center" class="td-footer"><xsl:value-of select="data/footer-text"/></td>
</tr>
</table>

</center>

</body>
</html>

</xsl:template>


</xsl:transform>
